Rem AnimationEncyclopedia.vbs
Rem An InDesign VBScript
Rem 
Rem Author:  Brenda Burden
Rem Creates a 6-page sample doc demonstrating the new InDesign Animation feature

Rem  Search Reference
Rem  PAGE ONE - Sample of Animation Properties 
Rem  PAGE TWO - Sample of all Animation Events
Rem  PAGE THREE - Sample of Additional Animation Properties and Settings, including Duration, Play count, Loop, Speed and Origin
Rem  PAGE FOUR - Sample of Animate To, Animate From, To Current location
Rem  PAGE FIVE - Sample of creating Timing Groups, setting Delays, and looping a Timing Group
Rem  PAGE SIX - Complex A-B-C-D animation that can be created only through scripting (cannot be created in the UI)
main
function main()
	Set myInDesign = CreateObject("InDesign.Application.2024")
	Set myDocument = myInDesign.documents.add
	mySetUnits myInDesign, idMeasurementUnits.idInches
	myDocument.transparencyPreferences.blendingSpace = idBlendingSpace.idRGB
	myDocument.documentPreferences.facingPages = false
	myDocument.documentPreferences.pageWidth = 11.111
	myDocument.documentPreferences.pageHeight = 8.333
	Set myRed = myMakeColor(myInDesign, "Red", idColorSpace.idRGB, idColorModel.idProcess, Array(255, 0, 0))
	Set myGreen = myMakeColor(myInDesign, "Green", idColorSpace.idRGB, idColorModel.idProcess, Array(0, 255, 0))
	Set myBlue = myMakeColor(myInDesign, "Blue", idColorSpace.idRGB, idColorModel.idProcess, Array(0, 0, 255))
	Set myPurple = myMakeColor(myInDesign, "Purple", idColorSpace.idRGB, idColorModel.idProcess, Array(200, 0, 255))
	Set myLightGray = myMakeColor(myInDesign, "Light Gray", idColorSpace.idRGB, idColorModel.idProcess, Array(200, 200, 200))
	Set myNoneSwatch = myDocument.swatches.item("None")
	Rem 
	Rem Page 1
	Rem 
	Rem Create a motion path using motionPathPoints. This is similar to drawing a regular path using the
	Rem entirePath property. If you wish to set keyframes to correspond to points in the path, use motionPath 
	Rem instead of motionPathPoints. See example on Page 6.
	mySetUnits myInDesign, idMeasurementUnits.idPoints
	myMotionPath = Array(Array(Array(Array(0,0),Array(0,0),Array(0,0)),Array(Array(565, 0),Array(565, 0),Array(565, 0)) ),true)
	myCurvedMotionPath = Array(Array(Array(Array(0,0),Array(0,0),Array(0,0)),Array(Array(565,0),Array(565,-150),Array(565,0)) ),true) 
	mySetUnits myInDesign, idMeasurementUnits.idInches
	Rem Create a background rectangle.
	myMakeRectangle myDocument.pages.item(1), Array(0,0,8.333,11.111), "Background Rectangle", myLightGray, myNoneSwatch, 0
	Rem Create a headline text frame.
	myMakeTextFrame myInDesign, myDocument.pages.item(1), Array(.25,0,1,11.111), "Animation Properties", "Myriad Pro", 28, idJustification.idCenterAlign, False
	Rem Add text labels.
	myMakeTextFrame myInDesign, myDocument.pages.item(1), Array(1.25,1,1.625,10.5), "Motion Path", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(1), Array(2.25,1,2.625,10.5), "Rotation", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(1), Array(3.25,1,3.625,10.5), "Opacity", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(1), Array(4.25,1,4.625,10.5), "Scale", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(1), Array(5.25,1,5.625,10.5), "Combination", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(1), Array(6.25,1,6.625,10.5), "Color Fade", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(1), Array(7.25,1,7.625,10.5), "Motion Path with Curve", "Myriad Pro", 18, idJustification.idLeftAlign, True
	Rem Add rectangles.
	Set myRectangle1P1 = myMakeRectangle(myDocument.pages.item(1), Array(1.625,1,2,2), "Motion Path Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle2P1 = myMakeRectangle(myDocument.pages.item(1), Array(2.625,1,3,2), "Rotation Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle3P1 = myMakeRectangle(myDocument.pages.item(1), Array(3.625,1,4,2), "Opacity Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle4P1 = myMakeRectangle(myDocument.pages.item(1), Array(4.625,1,5,2), "Scale Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle5P1 = myMakeRectangle(myDocument.pages.item(1), Array(5.625,1,6,2), "Combination Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle6P1 = myMakeRectangle(myDocument.pages.item(1), Array(6.625,1,7,2), "Color Fade Rectangle Blue", myBlue, myNoneSwatch, 0)
	Set myRectangle7P1 = myMakeRectangle(myDocument.pages.item(1), Array(6.625,1,7,2), "Color Fade Rectangle Purple", myPurple, myNoneSwatch, 0)
	Set myRectangle8P1 = myMakeRectangle(myDocument.pages.item(1), Array(7.625,1,8,2), "Motion Path with Curve Rectangle", myPurple, myNoneSwatch, 0)
	Rem Add animation properties.
	myRectangle1P1.animationSettings.motionPathPoints = myMotionPath
	myRectangle2P1.animationSettings.motionPathPoints = myMotionPath
	myRectangle2P1.animationSettings.rotationArray = Array(Array(0, 0), Array(23, 270))
	myRectangle3P1.animationSettings.motionPathPoints = myMotionPath
	myRectangle3P1.animationSettings.opacityArray = Array(Array(0,100),Array(23,10))  
	myRectangle4P1.animationSettings.motionPathPoints = myMotionPath
	myRectangle4P1.animationSettings.scaleXArray = Array(Array(0,100),Array(23,20))  
	myRectangle4P1.animationSettings.scaleYArray = Array(Array(0,100.0),Array(23,20))  
	myRectangle5P1.animationSettings.motionPathPoints = myMotionPath
	myRectangle5P1.animationSettings.scaleXArray = Array(Array(0,100),Array(23,120))  
	myRectangle5P1.animationSettings.scaleYArray = Array(Array(0,100),Array(23,10))  
	myRectangle5P1.animationSettings.rotationArray = Array(Array(0,0),Array(23,-270))  
	myRectangle5P1.animationSettings.opacityArray = Array(Array(0,100),Array(23,25))  
	myRectangle6P1.animationSettings.motionPathPoints = myMotionPath
	myRectangle6P1.animationSettings.opacityArray = Array(Array(0,0),Array(23,100)) 
	myRectangle7P1.animationSettings.motionPathPoints = myMotionPath
	myRectangle7P1.animationSettings.opacityArray = Array(Array(0,100),Array(23, 50)) 
	myRectangle8P1.animationSettings.motionPathPoints = myCurvedMotionPath
	Set myPageOneTimingSettings = myDocument.spreads.item(1).timingSettings
	Rem Remove the default On Page Load timing list.
	myPageOneTimingSettings.timingLists.item(1).delete
	Rem Add an On Page Click timing list.
	Set p1TimingOnPageClickList = myPageOneTimingSettings.timingLists.add(idDynamicTriggerEvents.idOnPageClick)
	Rem Add Animations as separate On Page Click Timing Groups
	Set p1timingGroup1 = p1TimingOnPageClickList.timingGroups.add(myRectangle1P1, 0)
	Set p1timingGroup2 = p1TimingOnPageClickList.timingGroups.add(myRectangle2P1, 0) 
	Set p1timingGroup3 = p1TimingOnPageClickList.timingGroups.add(myRectangle3P1, 0) 
	Set p1timingGroup4 = p1TimingOnPageClickList.timingGroups.add(myRectangle4P1, 0) 
	Set p1timingGroup5 = p1TimingOnPageClickList.timingGroups.add(myRectangle5P1, 0) 
	Set p1timingGroup6 = p1TimingOnPageClickList.timingGroups.add(myRectangle6P1, 0) 
	Rem Link Rectangle 6 and 7
	p1timingGroup6.timingTargets.add myRectangle7P1,0
	Set p1timingGroup7 = p1TimingOnPageClickList.timingGroups.add(myRectangle8P1, 0)
	Rem 
	Rem Page 2
	Rem 
	Set myMotionPreset = myInDesign.MotionPresets.Item("twirl")
	myDocument.Pages.Add
	Rem Create a background rectangle.
	myMakeRectangle myDocument.Pages.Item(2), Array(0,0,8.333,11.111), "Background Rectangle", myLightGray, myNoneSwatch, 0
	Rem Create a headline text frame.
	myMakeTextFrame myInDesign, myDocument.pages.item(2), Array(.25,0,1,11.111), "Animation Events", "Myriad Pro", 28, idJustification.idCenterAlign, False
	Rem Add text labels.
	myMakeTextFrame myInDesign, myDocument.pages.item(2), Array(1.25,1,1.625,10.5), "On Page Load", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(2), Array(2.25,1,2.625,10.5), "On Page Click", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(2), Array(3.25,1,3.625,10.5), "On Click (Self)", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(2), Array(4.25,1,4.625,10.5), "On Roll Over (Self)", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(2), Array(5.25,1,5.625,10.5), "On Button Event (On Click)", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(2), Array(6.25,1,6.625,10.5), "On State Load of Multi-State Object", "Myriad Pro", 18, idJustification.idLeftAlign, True
	Rem Add rectangles.
	Set myRectangle1P2 = myMakeRectangle(myDocument.pages.item(2), Array(1.625,1,2,2), "On Page Load Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle2P2 = myMakeRectangle(myDocument.pages.item(2), Array(2.625,1,3,2), "On Page Click Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle3P2 = myMakeRectangle(myDocument.pages.item(2), Array(3.625,1,4,2), "Self Click Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle4P2 = myMakeRectangle(myDocument.pages.item(2), Array(4.625,1,5,2), "Self Roll Over Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle5P2 = myMakeRectangle(myDocument.pages.item(2), Array(5.625,1,6,2), "On Button Event (On Click) Rectangle", myPurple, myNoneSwatch, 0)
	Rem Apply the motion preset to the rectangles.
	myRectangle1P2.AnimationSettings.Preset = myMotionPreset
	myRectangle2P2.AnimationSettings.Preset = myMotionPreset
	myRectangle3P2.AnimationSettings.Preset = myMotionPreset
	myRectangle4P2.AnimationSettings.Preset = myMotionPreset
	myRectangle5P2.AnimationSettings.Preset = myMotionPreset
	Rem Add a button to control the animation of myRectangle5P2.
	Set myPlayAnimationButton = myDocument.Pages.Item(2).Buttons.Add
	myPlayAnimationButton.GeometricBounds = Array(5.625,3,6,4)
	myPlayAnimationButton.Name = "Play Animation Button"
	myPlayAnimationButton.FillColor = myGreen
	myPlayAnimationButton.StrokeColor = myNoneSwatch
	Set myAnimationBehavior = myPlayAnimationButton.AnimationBehaviors.Add
	myAnimationBehavior.BehaviorEvent = idBehaviorEvents.idMouseDown
	myAnimationBehavior.EnableBehavior = True
	myAnimationBehavior.AnimatedPageItem = myRectangle5P2
	myAnimationBehavior.Operation = idAnimationPlayOperations.idPlay
	Rem Add a Multi-State Object (MSO).
	Set myMSO = myDocument.Pages.Item(2).multiStateObjects.add
	myMSO.GeometricBounds = Array(6.625,1,7,2)
	myMSO.Name = "Simple MSO"
	myMSO.InitiallyHidden = True
	Rem Name default states.
	myMSO.states.item(1).Name = "Top State"
	Set myTopState = myMSO.States.Item(1)
	myMSO.states.item(2).Name = "Second State"
	Set mySecondState = myMSO.States.Item(2)
	Set myThirdState = myMSO.States.Add
	myThirdState.Name = "Third State"
	Rem Add page items to the states.
	Set myRectangleMSO = myMakeRectangle(myTopState, Array(6.625,1,7,2), "Top State Rectangle", myPurple, myNoneSwatch, 0)
	myRectangleMSO.AnimationSettings.Preset = myMotionPreset
	Set myOvalMSO = myMakeRectangle(mySecondState, Array(6.625,1,7,2), "Second State Oval", myPurple, myNoneSwatch, 0)
	myOvalMSO.ConvertShape idConvertShapeOptions.idConvertToOval
	myOvalMSO.AnimationSettings.Preset = myMotionPreset
	Set myPolygonMSO = myMakeRectangle(myThirdState, Array(6.625,1,7,2), "Third State Polygon", myPurple, myNoneSwatch, 0)
	myPolygonMSO.ConvertShape idConvertShapeOptions.idConvertToPolygon
	myPolygonMSO.AnimationSettings.Preset = myMotionPreset
	Rem Add a button to control the animation of myMSO.
	Set myPlayMSOButton = myDocument.pages.item(2).buttons.add
	myPlayMSOButton.GeometricBounds = Array(6.625,3,7,4)
	myPlayMSOButton.Name = "Go to Next State of MSO Button"
	myPlayMSOButton.FillColor = myGreen
	myPlayMSOButton.StrokeColor = myNoneSwatch
	Set myMSOBehavior = myPlayMSOButton.GotoNextStateBehaviors.Add
	myMSOBehavior.AssociatedMultiStateObject = myMSO
	myMSOBehavior.LoopsToNextOrPrevious = True
	myMSOBehavior.BehaviorEvent = idBehaviorEvents.idMouseDown
	Rem Page 2 timing section:
	Set mySecondSpreadTimingSettings = myDocument.spreads.item(2).timingSettings
	Rem Remove the default timing list.
	mySecondSpreadTimingSettings.TimingLists.Item(1).Delete
	Rem Create On Page Load
	Set mySecondPageLoadTimingList = mySecondSpreadTimingSettings.TimingLists.add(idDynamicTriggerEvents.idOnPageLoad)
	Set secondSpreadTimingG1 = mySecondPageLoadTimingList.TimingGroups.Add(myRectangle1P2, 0)
	Rem Create On Page Click
	Set mySecondPageClickTimingList = mySecondSpreadTimingSettings.TimingLists.add(idDynamicTriggerEvents.idOnPageClick)
	Set secondSpreadTimingG2 = mySecondPageClickTimingList.TimingGroups.Add(myRectangle2P2, 0)
	Rem Create Self Click
	Set myRectangle3P2TimingList = myRectangle3P2.TimingSettings.TimingLists.Add(idDynamicTriggerEvents.idOnSelfClick)
	Rem Create Self Roll Over
	Set myRectangle4P2TimingList = myRectangle4P2.TimingSettings.TimingLists.Add(idDynamicTriggerEvents.idOnSelfRollover)	
	Rem 
	Rem Page 3
	Rem 
	myDocument.Pages.Add
	Rem Create a background rectangle.
	myMakeRectangle myDocument.Pages.Item(3), Array(0,0,8.333,11.111), "Background Rectangle", myLightGray, myNoneSwatch, 0
	Rem Create a headline text frame.
	myMakeTextFrame myInDesign, myDocument.pages.item(3), Array(.25,0,1,11.111), "Additional Animation Properties and Settings", "Myriad Pro", 28, idJustification.idCenterAlign, False
	Rem Add text labels.
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(1.25,1,1.625,10.5), "Duration: 2 seconds", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(2.25,1,2.625,10.5), "Duration: .5 seconds", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(3.25,1,3.625,10.5), "Speed: Ease In", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(4.25,1,4.625,10.5), "Speed: Ease Out", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(5.25,1,5.625,10.5), "Speed: Ease In and Out", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(6.25,1,6.625,10.5), "Play Twice", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(7.25,1,7.625,10.5), "Loop", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(1.25,5,1.625,10.5), "Hide Until Animated", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(2.25,5,2.625,10.5), "Hide After Animating", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(3.25,5,3.625,10.5), "Origin Upper Left Corner", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(4.25,5,4.625,10.5), "Origin Right, Vertical Center", "Myriad Pro", 18, idJustification.idLeftAlign, True
	Rem Add rectangles.
	Set myRectangle1P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(1.625,1,2,2), "2-Second Duration Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle2P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(2.625,1,3,2), ".5 Second Duration Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle3P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(3.625,1,4,2), "Ease In Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle4P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(4.625,1,5,2), "Ease Out Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle5P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(5.625,1,6,2), "Ease In and Out Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle6P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(6.625,1,7,2), "Play Twice Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle7P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(7.625,1,8,2), "Loop Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle8P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(1.625,5,2,6), "Hide Until Animated Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle9P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(2.625,5,3,6), "Hide After Animated Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle10P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(3.625,5,4,6), "Origin Upper Left Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle11P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(4.625,5,5,6), "Origin Right Center Rectangle", myPurple, myNoneSwatch, 0)
	Rem Set animation properties.
	myRectangle1P3.AnimationSettings.Duration = 2
	myRectangle1P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle2P3.AnimationSettings.Duration = 0.5
	myRectangle2P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(11,180))
	myRectangle3P3.AnimationSettings.Duration = 2
	myRectangle3P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle3P3.AnimationSettings.EaseType = idAnimationEaseOptions.idEaseIn
	myRectangle4P3.AnimationSettings.Duration = 2
	myRectangle4P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle4P3.AnimationSettings.EaseType = idAnimationEaseOptions.idEaseOut
	myRectangle5P3.AnimationSettings.Duration = 2
	myRectangle5P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle5P3.AnimationSettings.EaseType = idAnimationEaseOptions.idEaseInOut
	myRectangle6P3.AnimationSettings.Duration = 2
	myRectangle6P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle6P3.AnimationSettings.Plays = 2
	myRectangle7P3.AnimationSettings.Duration = 2
	myRectangle7P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle7P3.AnimationSettings.PlaysLoop = True
	myRectangle8P3.AnimationSettings.Duration = 2
	myRectangle8P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle8P3.AnimationSettings.InitiallyHidden = True
	myRectangle8P3.AnimationSettings.HiddenAfter = False
	myRectangle9P3.AnimationSettings.Duration = 2
	myRectangle9P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle9P3.AnimationSettings.InitiallyHidden = False
	myRectangle9P3.AnimationSettings.HiddenAfter = True
	myRectangle10P3.AnimationSettings.Duration = 2
	myRectangle10P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle10P3.AnimationSettings.TransformOffsets = Array(0, 0)
	myRectangle11P3.AnimationSettings.Duration = 2
	myRectangle11P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle11P3.AnimationSettings.TransformOffsets = Array(1.0,0.5)
	Rem 
	Rem Page 4
	Rem 
	myDocument.Pages.Add
	Rem Create a background rectangle.
	myMakeRectangle myDocument.Pages.Item(4), Array(0,0,8.333,11.111), "Background Rectangle", myLightGray, myNoneSwatch, 0
	Rem Create a headline text frame.
	myMakeTextFrame myInDesign, myDocument.Pages.Item(4), Array(.25,0,1,11.111), "Animate Options", "Myriad Pro", 28, idJustification.idCenterAlign, false
	Rem Add text labels.
	myMakeTextFrame myInDesign, myDocument.Pages.Item(4), Array(1.25,1,1.625,10.5), "Animate: From Current Appearance", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(4), Array(2.25,1,2.625,10.5), "Animate: To Current Appearance", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(4), Array(3.25,1,3.625,10.5), "Animate: To Current Location", "Myriad Pro", 18, idJustification.idLeftAlign, True
	Rem Add rectangles.
	Set myRectangle1P4 = myMakeRectangle(myDocument.Pages.Item(4), Array(1.625,1,2,2), "Animate From Current Appearance", myPurple, myNoneSwatch, 0)
	Set myRectangle2P4 = myMakeRectangle(myDocument.Pages.Item(4), Array(2.625,1,3,2), "Animate To Current Appearance", myPurple, myNoneSwatch, 0)
	set myRectangle3P4 = myMakeRectangle(myDocument.Pages.Item(4), Array(3.625,1,4,2), "Animate To Current Location", myPurple, myNoneSwatch, 0)
	Rem Set animation properties.
	myRectangle1P4.AnimationSettings.Preset = myInDesign.MotionPresets.Item("move-right-grow")
	myRectangle1P4.AnimationSettings.DesignOption = idDesignOptions.idFromCurrentAppearance
	myRectangle2P4.AnimationSettings.Preset =  myInDesign.MotionPresets.Item("move-right-grow")
	myRectangle2P4.AnimationSettings.DesignOption = idDesignOptions.idToCurrentAppearance
	myRectangle3P4.AnimationSettings.Preset = myInDesign.MotionPresets.Item("fly-in-left")
	Rem 
	Rem Page 5
	Rem 
	myDocument.Pages.Add
	Rem Create a background rectangle.
	myMakeRectangle myDocument.Pages.Item(5), Array(0,0,8.333,11.111), "Background Rectangle", myLightGray, myNoneSwatch, 0
	Rem Create a headline text frame.
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(.25,0,1,11.111), "Timing Panel - Timing Groups and Delays", "Myriad Pro", 28, idJustification.idCenterAlign, false
	Rem Add text labels.
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(1.25,1,1.625,10.5), "A-1", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(2.25,1,2.625,10.5), "A-2", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(3.25,1,3.625,10.5), "A-3", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(4.25,1,4.625,10.5), "A-4", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(5.25,1,5.625,10.5), "B-1", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(6.25,1,6.625,10.5), "B-2", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(7.25,1,7.625,10.5), "B-3", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(1.25,5,1.625,10.5), "C-1", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(2.25,5,2.625,10.5), "C-2", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(3.25,5,3.625,10.5), "C-3", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(4.25,5,4.625,10.5), "C-4", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(5.25,5,5.625,10.5), "C-5", "Myriad Pro", 18, idJustification.idLeftAlign, True
	Rem Add rectangles.
	Set myRectangle1P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(1.625,1,2,2), "A-1", myPurple, myNoneSwatch, 0)
	Set myRectangle2P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(2.625,1,3,2), "A-2", myPurple, myNoneSwatch, 0)
	Set myRectangle3P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(3.625,1,4,2), "A-3", myPurple, myNoneSwatch, 0)
	Set myRectangle4P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(4.625,1,5,2), "A-4", myPurple, myNoneSwatch, 0)
	Set myRectangle5P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(5.625,1,6,2), "B-1", myGreen, myNoneSwatch, 0)
	Set myRectangle6P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(6.625,1,7,2), "B-2", myGreen, myNoneSwatch, 0)
	Set myRectangle7P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(7.625,1,8,2), "B-3", myGreen, myNoneSwatch, 0)
	Set myRectangle8P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(1.625,5,2,6), "C-1", myBlue, myNoneSwatch, 0)
	Set myRectangle9P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(2.625,5,3,6), "C-2", myBlue, myNoneSwatch, 0)
	Set myRectangle10P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(3.625,5,4,6), "C-3", myBlue, myNoneSwatch, 0)
	Set myRectangle11P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(4.625,5,5,6), "C-4", myBlue, myNoneSwatch, 0)
	Set myRectangle12P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(5.625,5,6,6), "C-5", myBlue, myNoneSwatch, 0)
	Rem Animation settings (note that you cannot use a page item as the target of a timing group
	Rem if you have not applied animation settings to the it).
	myRectangle1P5.AnimationSettings.Preset = myMotionPreset
	myRectangle2P5.AnimationSettings.Preset = myMotionPreset
	myRectangle3P5.AnimationSettings.Preset = myMotionPreset
	myRectangle4P5.AnimationSettings.Preset = myMotionPreset
	myRectangle5P5.AnimationSettings.Preset = myMotionPreset
	myRectangle6P5.AnimationSettings.Preset = myMotionPreset
	myRectangle7P5.AnimationSettings.Preset = myMotionPreset
	myRectangle8P5.AnimationSettings.Preset = myMotionPreset
	myRectangle9P5.AnimationSettings.Preset = myMotionPreset
	myRectangle10P5.AnimationSettings.Preset = myMotionPreset
	myRectangle11P5.AnimationSettings.Preset = myMotionPreset
	myRectangle12P5.AnimationSettings.Preset = myMotionPreset
	Rem Page 5 timing section:
	Set myFifthSpreadTimingSettings = myRectangle1P5.parent.TimingSettings
	myFifthSpreadTimingSettings.TimingLists.item(1).Delete
	Set myFifthPageLoadTimingList = myFifthSpreadTimingSettings.TimingLists.Add(idDynamicTriggerEvents.idOnPageLoad)
	Rem A group.
	Set myFifthSpreadTimingG1 = myFifthPageLoadTimingList.TimingGroups.Add(myRectangle1P5, 0)
	myFifthSpreadTimingG1.TimingTargets.Add myRectangle2P5, 0
	myFifthSpreadTimingG1.TimingTargets.Add myRectangle3P5, 0
	myFifthSpreadTimingG1.TimingTargets.Add myRectangle4P5, 0
	Rem B group.
	Set myFifthSpreadTimingG2 = myFifthPageLoadTimingList.TimingGroups.Add(myRectangle5P5, 1)
	myFifthSpreadTimingG2.TimingTargets.Add myRectangle6P5,.5
	myFifthSpreadTimingG2.TimingTargets.Add myRectangle7P5, 1
	Rem Enable Group Loop
	myFifthSpreadTimingG2.PlaysLoop = True
	Rem C group.
	Set myFifthSpreadTimingG3 = myFifthPageLoadTimingList.TimingGroups.Add(myRectangle8P5, .25)
	myFifthSpreadTimingG3.TimingTargets.Add myRectangle9P5, .25
	myFifthSpreadTimingG3.TimingTargets.Add myRectangle10P5, .25
	myFifthSpreadTimingG3.TimingTargets.Add myRectangle11P5, .25
	myFifthSpreadTimingG3.TimingTargets.Add myRectangle12P5, .25
	Rem Enable Group Plays 2
	myFifthSpreadTimingG3.Plays = 2
	Rem 
	Rem Page 6
	Rem 
	myDocument.pages.add()
	Rem Create a background rectangle.
	myMakeRectangle myDocument.Pages.Item(6), Array(0,0,8.333,11.111), "Background Rectangle", myLightGray, myNoneSwatch, 0
	Rem Create a headline text frame.
	myMakeTextFrame myInDesign, myDocument.Pages.Item(6), Array(.25,0,1,11.111), "Scripted Animation with Multiple Property Changes", "Myriad Pro", 28, idJustification.idCenterAlign, false
	Rem Add text label.
	myMakeTextFrame myInDesign, myDocument.Pages.Item(6), Array(1.25,1,1.625,10.5), "6-Second Animation with one or more property changes per second", "Myriad Pro", 18, idJustification.idLeftAlign, True
	Rem Add rectangle.
	Set myRectangle1P6 = myMakeRectangle(myDocument.Pages.Item(6), Array(1.625,1,2,2), "Scripted Animation Rectangle", myPurple, myNoneSwatch, 0)
	Rem Set duration before adding keyframes when scripting animations
	myRectangle1P6.AnimationSettings.duration = 6
	Rem Assumes 24 Frames Per Second (FPS)
	Rem 23 = 1 second, 47 = 2 seconds, 71 = 3 seconds, 95 = 4 seconds, 119 = 5 seconds, 143 = 6 seconds
	mySetUnits myInDesign, idMeasurementUnits.idPoints
	Rem Note that the animation here is created with motionPath, which allows for setting keyframes that correspond to points in the path
	myRectangle1P6.AnimationSettings.MotionPath = Array(Array(0, Array(Array(0, 0), Array(0, 0), Array(0, 0))), Array(23, Array(Array(200, 0), Array(200, 0), Array(200, 0))), Array(47, Array(Array(200, 200), Array(200, 200), Array(200, 200))), Array(119, Array(Array(0, 200), Array(0, 200), Array(0, 200))), Array(143, Array(Array(0, 0), Array(0, 0), Array(0, 0))))
	mySetUnits myInDesign, idMeasurementUnits.idInches
	Rem Note that this animation allows setting multiple changes in opacity, scale and rotation that 
	Rem correspond to points in the motion path.  This functionality is not available in the Animation panel UI.
	myRectangle1P6.AnimationSettings.RotationArray =  Array(Array(0, 0), Array(23, 180), Array(47, 0), Array(71, -180), Array(95, 0), Array(119, 180), Array(143, -360))
	myRectangle1P6.AnimationSettings.ScaleXArray = Array( Array(0, 100.0 ), Array(23, 200.0), Array(47, 100.0), Array(71, 300.0), Array(95, 100.0), Array(119, 200.0), Array(143, 100.0) )
	myRectangle1P6.AnimationSettings.ScaleYArray = Array( Array(0, 100.0 ), Array(23, 0.0), Array(47, 100.0), Array(71, 0.0), Array(95, 100.0), Array(119, 300.0), Array(143, 100.0) )
	myRectangle1P6.AnimationSettings.OpacityArray = Array( Array(0, 100.0 ), Array(23, 0.0), Array(47, 100.0), Array(71, 0.0), Array(95, 100.0), Array(119, 0.0), Array(143, 100.0) ) 
	myRectangle1P6.AnimationSettings.Plays = 1
	myRectangle1P6.AnimationSettings.PlaysLoop = False
	myRectangle1P6.AnimationSettings.EaseType = idAnimationEaseOptions.idNoEase
	myRectangle1P6.AnimationSettings.TransformOffsets = Array(0.5, 0.5)
	myRectangle1P6.AnimationSettings.DesignOption = idDesignOptions.idFromCurrentAppearance 
	myRectangle1P6.AnimationSettings.InitiallyHidden = False
	myRectangle1P6.AnimationSettings.HiddenAfter = False		
End Function
Rem Utility functions.
Function mySetUnits(myInDesign, myUnits)
	myInDesign.Documents.Item(1).ViewPreferences.HorizontalMeasurementUnits = myUnits
	myInDesign.Documents.Item(1).ViewPreferences.VerticalMeasurementUnits = myUnits
End Function
Function myMakeTextFrame(myInDesign, myPage, myBounds, myString, myFontName, myPointSize, myJustification, myFitToContent)
	Set myTextFrame = myPage.TextFrames.Add
	myTextFrame.GeometricBounds = myBounds
	myTextFrame.Texts.Item(1).InsertionPoints.Item(1).Contents = myString
	myTextFrame.Texts.Item(1).ParentStory.AppliedFont = myInDesign.Fonts.Item(myFontName)
	myTextFrame.Texts.Item(1).ParentStory.PointSize = myPointSize
	myTextFrame.Texts.Item(1).ParentStory.FillColor = myInDesign.Documents.Item(1).Swatches.Item("Black")
	myTextFrame.Texts.Item(1).Justification = myJustification
	If myFitToContent = True Then
		myTextFrame.Fit idFitOptions.idFrameToContent
	End If
	Set myMakeTextFrame = myTextFrame
End Function
Function myMakeRectangle(myPage, myBounds, myString, myFillColor,  myStrokeColor, myStrokeWeight)
	Set myRectangle = myPage.rectangles.Add
	myRectangle.GeometricBounds = myBounds
	myRectangle.fillColor = myFillColor
	myRectangle.strokeWeight = myStrokeWeight
	myRectangle.strokeColor = myStrokeColor
	myRectangle.name = myString
	Set myMakeRectangle = myRectangle
End Function
Function myMakeColor(myInDesign, myColorName, myColorSpace, myColorModel, myColorValue)
	Set myDocument = myInDesign.Documents.Item(1)
	Rem Something like a try...catch for VBScript.
    On Error Resume Next
    Set myColor = myDocument.Colors.Item(myColorName)
    If Err.Number <> 0 Then
        Set myColor = myDocument.Colors.Add
    End If
    Err.Clear
    On Error GoTo 0
	myColor.Name = myColorName
	myColor.Space = myColorSpace
	myColor.Model = myColorModel
	myColor.ColorValue = myColorValue
	Set myMakeColor = myColor
End Function

'' SIG '' Begin signature block
'' SIG '' MIIpyQYJKoZIhvcNAQcCoIIpujCCKbYCAQExDzANBglg
'' SIG '' hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
'' SIG '' BgEEAYI3AgEeMCQCAQEEEE7wKRaZJ7VNj+Ws4Q8X66sC
'' SIG '' AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
'' SIG '' xpuXGY7zcDXfc4mE883lw/WY5/zESsMnGCKupPEDgpSg
'' SIG '' gg6WMIIGsDCCBJigAwIBAgIQCK1AsmDSnEyfXs2pvZOu
'' SIG '' 2TANBgkqhkiG9w0BAQwFADBiMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQDExhEaWdpQ2Vy
'' SIG '' dCBUcnVzdGVkIFJvb3QgRzQwHhcNMjEwNDI5MDAwMDAw
'' SIG '' WhcNMzYwNDI4MjM1OTU5WjBpMQswCQYDVQQGEwJVUzEX
'' SIG '' MBUGA1UEChMORGlnaUNlcnQsIEluYy4xQTA/BgNVBAMT
'' SIG '' OERpZ2lDZXJ0IFRydXN0ZWQgRzQgQ29kZSBTaWduaW5n
'' SIG '' IFJTQTQwOTYgU0hBMzg0IDIwMjEgQ0ExMIICIjANBgkq
'' SIG '' hkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA1bQvQtAorXi3
'' SIG '' XdU5WRuxiEL1M4zrPYGXcMW7xIUmMJ+kjmjYXPXrNCQH
'' SIG '' 4UtP03hD9BfXHtr50tVnGlJPDqFX/IiZwZHMgQM+TXAk
'' SIG '' ZLON4gh9NH1MgFcSa0OamfLFOx/y78tHWhOmTLMBICXz
'' SIG '' ENOLsvsI8IrgnQnAZaf6mIBJNYc9URnokCF4RS6hnyzh
'' SIG '' GMIazMXuk0lwQjKP+8bqHPNlaJGiTUyCEUhSaN4QvRRX
'' SIG '' XegYE2XFf7JPhSxIpFaENdb5LpyqABXRN/4aBpTCfMjq
'' SIG '' GzLmysL0p6MDDnSlrzm2q2AS4+jWufcx4dyt5Big2MEj
'' SIG '' R0ezoQ9uo6ttmAaDG7dqZy3SvUQakhCBj7A7CdfHmzJa
'' SIG '' wv9qYFSLScGT7eG0XOBv6yb5jNWy+TgQ5urOkfW+0/tv
'' SIG '' k2E0XLyTRSiDNipmKF+wc86LJiUGsoPUXPYVGUztYuBe
'' SIG '' M/Lo6OwKp7ADK5GyNnm+960IHnWmZcy740hQ83eRGv7b
'' SIG '' UKJGyGFYmPV8AhY8gyitOYbs1LcNU9D4R+Z1MI3sMJN2
'' SIG '' FKZbS110YU0/EpF23r9Yy3IQKUHw1cVtJnZoEUETWJrc
'' SIG '' JisB9IlNWdt4z4FKPkBHX8mBUHOFECMhWWCKZFTBzCEa
'' SIG '' 6DgZfGYczXg4RTCZT/9jT0y7qg0IU0F8WD1Hs/q27Iwy
'' SIG '' CQLMbDwMVhECAwEAAaOCAVkwggFVMBIGA1UdEwEB/wQI
'' SIG '' MAYBAf8CAQAwHQYDVR0OBBYEFGg34Ou2O/hfEYb7/mF7
'' SIG '' CIhl9E5CMB8GA1UdIwQYMBaAFOzX44LScV1kTN8uZz/n
'' SIG '' upiuHA9PMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAK
'' SIG '' BggrBgEFBQcDAzB3BggrBgEFBQcBAQRrMGkwJAYIKwYB
'' SIG '' BQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBB
'' SIG '' BggrBgEFBQcwAoY1aHR0cDovL2NhY2VydHMuZGlnaWNl
'' SIG '' cnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcnQw
'' SIG '' QwYDVR0fBDwwOjA4oDagNIYyaHR0cDovL2NybDMuZGln
'' SIG '' aWNlcnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5j
'' SIG '' cmwwHAYDVR0gBBUwEzAHBgVngQwBAzAIBgZngQwBBAEw
'' SIG '' DQYJKoZIhvcNAQEMBQADggIBADojRD2NCHbuj7w6mdNW
'' SIG '' 4AIapfhINPMstuZ0ZveUcrEAyq9sMCcTEp6QRJ9L/Z6j
'' SIG '' fCbVN7w6XUhtldU/SfQnuxaBRVD9nL22heB2fjdxyyL3
'' SIG '' WqqQz/WTauPrINHVUHmImoqKwba9oUgYftzYgBoRGRjN
'' SIG '' YZmBVvbJ43bnxOQbX0P4PpT/djk9ntSZz0rdKOtfJqGV
'' SIG '' WEjVGv7XJz/9kNF2ht0csGBc8w2o7uCJob054ThO2m67
'' SIG '' Np375SFTWsPK6Wrxoj7bQ7gzyE84FJKZ9d3OVG3ZXQIU
'' SIG '' H0AzfAPilbLCIXVzUstG2MQ0HKKlS43Nb3Y3LIU/Gs4m
'' SIG '' 6Ri+kAewQ3+ViCCCcPDMyu/9KTVcH4k4Vfc3iosJocsL
'' SIG '' 6TEa/y4ZXDlx4b6cpwoG1iZnt5LmTl/eeqxJzy6kdJKt
'' SIG '' 2zyknIYf48FWGysj/4+16oh7cGvmoLr9Oj9FpsToFpFS
'' SIG '' i0HASIRLlk2rREDjjfAVKM7t8RhWByovEMQMCGQ8M4+u
'' SIG '' KIw8y4+ICw2/O/TOHnuO77Xry7fwdxPm5yg/rBKupS8i
'' SIG '' bEH5glwVZsxsDsrFhsP2JjMMB0ug0wcCampAMEhLNKhR
'' SIG '' ILutG4UI4lkNbcoFUCvqShyepf2gpx8GdOfy1lKQ/a+F
'' SIG '' SCH5Vzu0nAPthkX0tGFuv2jiJmCG6sivqf6UHedjGzqG
'' SIG '' VnhOMIIH3jCCBcagAwIBAgIQD99ExMbwCe2qSx8hp1o/
'' SIG '' EDANBgkqhkiG9w0BAQsFADBpMQswCQYDVQQGEwJVUzEX
'' SIG '' MBUGA1UEChMORGlnaUNlcnQsIEluYy4xQTA/BgNVBAMT
'' SIG '' OERpZ2lDZXJ0IFRydXN0ZWQgRzQgQ29kZSBTaWduaW5n
'' SIG '' IFJTQTQwOTYgU0hBMzg0IDIwMjEgQ0ExMB4XDTIzMTEw
'' SIG '' MzAwMDAwMFoXDTI1MTEwNDIzNTk1OVowgeYxEzARBgsr
'' SIG '' BgEEAYI3PAIBAxMCVVMxGTAXBgsrBgEEAYI3PAIBAhMI
'' SIG '' RGVsYXdhcmUxHTAbBgNVBA8MFFByaXZhdGUgT3JnYW5p
'' SIG '' emF0aW9uMRAwDgYDVQQFEwcyNzQ4MTI5MQswCQYDVQQG
'' SIG '' EwJVUzELMAkGA1UECBMCY2ExETAPBgNVBAcTCFNhbiBK
'' SIG '' b3NlMRMwEQYDVQQKEwpBZG9iZSBJbmMuMSwwKgYDVQQL
'' SIG '' EyNJbGx1c3RyYXRvciwgSW5EZXNpZ24sIEluQ29weSwg
'' SIG '' TXVzZTETMBEGA1UEAxMKQWRvYmUgSW5jLjCCAiIwDQYJ
'' SIG '' KoZIhvcNAQEBBQADggIPADCCAgoCggIBAPCR5c/cgyg4
'' SIG '' MpJD46/+BWENPhE1RjN77VE2BWlIUdiO2nlWelKthEq9
'' SIG '' aK+1ofKIlDVc9mvxksuXBLESi7HBt3PCVBntNJkjBJd0
'' SIG '' EXeprmDK8HZrz8y/KSwEewbTMjneMRIRcJV2GMoAyUzK
'' SIG '' EyFJF7m6ByeoNBDDXMD4AQF5C2l3wfvRbREw+G+cyeya
'' SIG '' 564AHpFJ9sfqi9jAycnEZISxEf6N72GgGQr04cZt3JTb
'' SIG '' TktZGt6uWdZnseXDLGRHzFu4P4EqmVKvfMDliaKyWBzV
'' SIG '' lY+gmtE1vSxIK79WTySFrFY5j1vtbKyHybk6tv4TOmLt
'' SIG '' Lw4OP/ngVDiw/ZP+b7saGxPOEfuh5LOAr+llt+6V5NhT
'' SIG '' dkYPR6cbokawwX2DbGg7IeVuUPdf9bx/LznFV/8kPxCB
'' SIG '' J6qg0dqvCmQt/XbBXPJUvDoVJ9z+9hDlrAoLESqpHK8U
'' SIG '' 73UFGohBMJ/7itIyKngem7Ms98z6x0i63FJA8C06g+XE
'' SIG '' GJUmR28+c6ba+m/sc6xHI4zdL5a84UeRS9+u8UL8N4av
'' SIG '' fpSxHYTTxVjk1ZlwQ8dLARwEVWvTu4lRcEck3RPogx7o
'' SIG '' o8wUpSw9++m+Oi+K/z7RP/R67uCEtrkdM5N/xUoQR/t6
'' SIG '' 3P2ia9g8+LuYJ2BNBd1+qMcSoSlDfIFLFMeeqESbMv+j
'' SIG '' UsRQJn2lZvufAgMBAAGjggICMIIB/jAfBgNVHSMEGDAW
'' SIG '' gBRoN+Drtjv4XxGG+/5hewiIZfROQjAdBgNVHQ4EFgQU
'' SIG '' RPnrJ9yT26rMrd/Q4PfQSlgeaRcwPQYDVR0gBDYwNDAy
'' SIG '' BgVngQwBAzApMCcGCCsGAQUFBwIBFhtodHRwOi8vd3d3
'' SIG '' LmRpZ2ljZXJ0LmNvbS9DUFMwDgYDVR0PAQH/BAQDAgeA
'' SIG '' MBMGA1UdJQQMMAoGCCsGAQUFBwMDMIG1BgNVHR8Ega0w
'' SIG '' gaowU6BRoE+GTWh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNv
'' SIG '' bS9EaWdpQ2VydFRydXN0ZWRHNENvZGVTaWduaW5nUlNB
'' SIG '' NDA5NlNIQTM4NDIwMjFDQTEuY3JsMFOgUaBPhk1odHRw
'' SIG '' Oi8vY3JsNC5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVz
'' SIG '' dGVkRzRDb2RlU2lnbmluZ1JTQTQwOTZTSEEzODQyMDIx
'' SIG '' Q0ExLmNybDCBlAYIKwYBBQUHAQEEgYcwgYQwJAYIKwYB
'' SIG '' BQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBc
'' SIG '' BggrBgEFBQcwAoZQaHR0cDovL2NhY2VydHMuZGlnaWNl
'' SIG '' cnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZEc0Q29kZVNpZ25p
'' SIG '' bmdSU0E0MDk2U0hBMzg0MjAyMUNBMS5jcnQwCQYDVR0T
'' SIG '' BAIwADANBgkqhkiG9w0BAQsFAAOCAgEAPIZ9C4IuKg85
'' SIG '' 0H8M66OLMVllIpANmEjijIG/D65qP6jfma+2WFps2bb+
'' SIG '' vKKIEtG9TFtCAlSrA1OV6Ru78paq0gqw/q3QAN0OleFR
'' SIG '' F1NvT/TLO0ulhjXTETB1BwSKZaJH001DH0+60TmbGfVh
'' SIG '' mwLrEj2Zfl4COFwivZ/2tRoknZl5tmiu4hpjDbOapWd9
'' SIG '' 5cqliSoMeu2i588557eikdiDk6bXBa5MxHjyXvbvaIWN
'' SIG '' Zjsymn0L0sYkF3BToDN0h0XiTTZjZPHdSV2GjX6C/+Nj
'' SIG '' HSZGRtBaIxdAL1mKEWJV9qkEKELPb098rO+zGdn1E5IH
'' SIG '' pS1zSRIYngwZEjZfyoCkg1F+EW4QPs2+ff2CsW5i3IEd
'' SIG '' 7vL19w9oyce3S4wejvnlTKt+EQWn3gSPxrbkp3BxdWRN
'' SIG '' 25MKo5bS5bJ21BiwqcIJHcTxWNgaQPh4sZboi9IimCSn
'' SIG '' UenPQhqdeOuz0NnmepMEYd7L/kqnAeUZ8bW1UbITAWQ/
'' SIG '' UT3phjCfRQNpEh4OBoUcH8hOOHZ0Lh86mxv9lDP3i7c/
'' SIG '' bQzZnrJr2dS34JXolwREbTX9Yu5JB5X3YP539/M1Ms5O
'' SIG '' FZou/MHQBrWMsVBsEXDTWqwbMTYw/zvIiHXcGUnpzInw
'' SIG '' 1jQXlLrmwVHW4ug+A4LFO7bWC4mnZoDNWp0xnlGmbP6I
'' SIG '' ccJmW5C7RJMxghqLMIIahwIBATB9MGkxCzAJBgNVBAYT
'' SIG '' AlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjFBMD8G
'' SIG '' A1UEAxM4RGlnaUNlcnQgVHJ1c3RlZCBHNCBDb2RlIFNp
'' SIG '' Z25pbmcgUlNBNDA5NiBTSEEzODQgMjAyMSBDQTECEA/f
'' SIG '' RMTG8AntqksfIadaPxAwDQYJYIZIAWUDBAIBBQCggZww
'' SIG '' GQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYB
'' SIG '' BAGCNwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcN
'' SIG '' AQkEMSIEIEkJSPMs87diTSwID3bOkllwUWrY2O7c035J
'' SIG '' KYH/EyToMDAGCisGAQQBgjcCAQwxIjAgoB6AHABBAGQA
'' SIG '' bwBiAGUAIABJAG4ARABlAHMAaQBnAG4wDQYJKoZIhvcN
'' SIG '' AQEBBQAEggIAsh+cZLUPsd3lObZS+jucGL3hwAjiKVDF
'' SIG '' xi509WXIxaGaBgyUslEv+oLAwAy4kObtZDq+0ZA9IWOe
'' SIG '' 5la9MxcBI5xtIyYmNgJocMKJ7zk/t5jspILv/OBi/aPU
'' SIG '' keWTwJl9Ymiraofjnnll+4FveQPp45QrVxexeAOckHcf
'' SIG '' gsXNtd9EpU5VltnYKGi0krHawXQHEK5xP14Dj0AL+rJI
'' SIG '' TahFIZhIOGI6wAWqNPVQfxEQoLjyhuQOATsiXDOnuKhM
'' SIG '' EluvoTMcp71vxrRvjP8XupEvSWwoT2RdPYaWkNtaXt+f
'' SIG '' tEXjOIF8axZ4Bp/nk5RZOpHAe42dFs4FYL5A1YqdwQM+
'' SIG '' vgNdT85QmzuxWJYRUfsQZ9dwpXKv+iZ0Q9gXBriI8Alz
'' SIG '' bRWvgQXrhtYu3vS++ThVWO43rzZb2DUr3qVrvUNthBwm
'' SIG '' vDxFsaTN793XwBzB/UWUu049oDSipbSKZ0fXGZWO8vH1
'' SIG '' jM+DU7EsPDXcPe0JY+1dXK7/yE387ZYiG19sLEt9VcXu
'' SIG '' TRF9bx6178JmBc2OlUJO4i/TM+MO3SxpnQPBCXFCvQNw
'' SIG '' MhjqS/jAXBXSR2ISD3RunusaGogWeNglxAmI8gYH4/vN
'' SIG '' BBJTdVM6D+JzC4LC2HISpgrnCR2E5p0cCAPpCoNJn8FB
'' SIG '' iesfs+IFId4u7ySv2gJqu7twJA7lRpndxKChghdAMIIX
'' SIG '' PAYKKwYBBAGCNwMDATGCFywwghcoBgkqhkiG9w0BBwKg
'' SIG '' ghcZMIIXFQIBAzEPMA0GCWCGSAFlAwQCAQUAMHgGCyqG
'' SIG '' SIb3DQEJEAEEoGkEZzBlAgEBBglghkgBhv1sBwEwMTAN
'' SIG '' BglghkgBZQMEAgEFAAQgXOWPPWYVwaMjtAZXPMP1fk11
'' SIG '' IgT41Irl7OG4lk3MVXsCEQDatgWfIGnn8faUn2H0tD+X
'' SIG '' GA8yMDI0MDEyNjIzNTQ0MlqgghMJMIIGwjCCBKqgAwIB
'' SIG '' AgIQBUSv85SdCDmmv9s/X+VhFjANBgkqhkiG9w0BAQsF
'' SIG '' ADBjMQswCQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNl
'' SIG '' cnQsIEluYy4xOzA5BgNVBAMTMkRpZ2lDZXJ0IFRydXN0
'' SIG '' ZWQgRzQgUlNBNDA5NiBTSEEyNTYgVGltZVN0YW1waW5n
'' SIG '' IENBMB4XDTIzMDcxNDAwMDAwMFoXDTM0MTAxMzIzNTk1
'' SIG '' OVowSDELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lD
'' SIG '' ZXJ0LCBJbmMuMSAwHgYDVQQDExdEaWdpQ2VydCBUaW1l
'' SIG '' c3RhbXAgMjAyMzCCAiIwDQYJKoZIhvcNAQEBBQADggIP
'' SIG '' ADCCAgoCggIBAKNTRYcdg45brD5UsyPgz5/X5dLnXaEO
'' SIG '' CdwvSKOXejsqnGfcYhVYwamTEafNqrJq3RApih5iY2nT
'' SIG '' WJw1cb86l+uUUI8cIOrHmjsvlmbjaedp/lvD1isgHMGX
'' SIG '' lLSlUIHyz8sHpjBoyoNC2vx/CSSUpIIa2mq62DvKXd4Z
'' SIG '' GIX7ReoNYWyd/nFexAaaPPDFLnkPG2ZS48jWPl/aQ9OE
'' SIG '' 9dDH9kgtXkV1lnX+3RChG4PBuOZSlbVH13gpOWvgeFmX
'' SIG '' 40QrStWVzu8IF+qCZE3/I+PKhu60pCFkcOvV5aDaY7Mu
'' SIG '' 6QXuqvYk9R28mxyyt1/f8O52fTGZZUdVnUokL6wrl76f
'' SIG '' 5P17cz4y7lI0+9S769SgLDSb495uZBkHNwGRDxy1Uc2q
'' SIG '' TGaDiGhiu7xBG3gZbeTZD+BYQfvYsSzhUa+0rRUGFOpi
'' SIG '' CBPTaR58ZE2dD9/O0V6MqqtQFcmzyrzXxDtoRKOlO0L9
'' SIG '' c33u3Qr/eTQQfqZcClhMAD6FaXXHg2TWdc2PEnZWpST6
'' SIG '' 18RrIbroHzSYLzrqawGw9/sqhux7UjipmAmhcbJsca8+
'' SIG '' uG+W1eEQE/5hRwqM/vC2x9XH3mwk8L9CgsqgcT2ckpME
'' SIG '' tGlwJw1Pt7U20clfCKRwo+wK8REuZODLIivK8SgTIUlR
'' SIG '' fgZm0zu++uuRONhRB8qUt+JQofM604qDy0B7AgMBAAGj
'' SIG '' ggGLMIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/
'' SIG '' BAIwADAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAgBgNV
'' SIG '' HSAEGTAXMAgGBmeBDAEEAjALBglghkgBhv1sBwEwHwYD
'' SIG '' VR0jBBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYD
'' SIG '' VR0OBBYEFKW27xPn783QZKHVVqllMaPe1eNJMFoGA1Ud
'' SIG '' HwRTMFEwT6BNoEuGSWh0dHA6Ly9jcmwzLmRpZ2ljZXJ0
'' SIG '' LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEy
'' SIG '' NTZUaW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEB
'' SIG '' BIGDMIGAMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5k
'' SIG '' aWdpY2VydC5jb20wWAYIKwYBBQUHMAKGTGh0dHA6Ly9j
'' SIG '' YWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0
'' SIG '' ZWRHNFJTQTQwOTZTSEEyNTZUaW1lU3RhbXBpbmdDQS5j
'' SIG '' cnQwDQYJKoZIhvcNAQELBQADggIBAIEa1t6gqbWYF7xw
'' SIG '' jU+KPGic2CX/yyzkzepdIpLsjCICqbjPgKjZ5+PF7SaC
'' SIG '' inEvGN1Ott5s1+FgnCvt7T1IjrhrunxdvcJhN2hJd6Pr
'' SIG '' kKoS1yeF844ektrCQDifXcigLiV4JZ0qBXqEKZi2V3mP
'' SIG '' 2yZWK7Dzp703DNiYdk9WuVLCtp04qYHnbUFcjGnRuSvE
'' SIG '' xnvPnPp44pMadqJpddNQ5EQSviANnqlE0PjlSXcIWiHF
'' SIG '' tM+YlRpUurm8wWkZus8W8oM3NG6wQSbd3lqXTzON1I13
'' SIG '' fXVFoaVYJmoDRd7ZULVQjK9WvUzF4UbFKNOt50MAcN7M
'' SIG '' mJ4ZiQPq1JE3701S88lgIcRWR+3aEUuMMsOI5ljitts+
'' SIG '' +V+wQtaP4xeR0arAVeOGv6wnLEHQmjNKqDbUuXKWfpd5
'' SIG '' OEhfysLcPTLfddY2Z1qJ+Panx+VPNTwAvb6cKmx5Adza
'' SIG '' ROY63jg7B145WPR8czFVoIARyxQMfq68/qTreWWqaNYi
'' SIG '' yjvrmoI1VygWy2nyMpqy0tg6uLFGhmu6F/3Ed2wVbK6r
'' SIG '' r3M66ElGt9V/zLY4wNjsHPW2obhDLN9OTH0eaHDAdwrU
'' SIG '' AuBcYLso/zjlUlrWrBciI0707NMX+1Br/wd3H3GXREHJ
'' SIG '' uEbTbDJ8WC9nR2XlG3O2mflrLAZG70Ee8PBf4NvZrZCA
'' SIG '' RK+AEEGKMIIGrjCCBJagAwIBAgIQBzY3tyRUfNhHrP0o
'' SIG '' ZipeWzANBgkqhkiG9w0BAQsFADBiMQswCQYDVQQGEwJV
'' SIG '' UzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQL
'' SIG '' ExB3d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQDExhEaWdp
'' SIG '' Q2VydCBUcnVzdGVkIFJvb3QgRzQwHhcNMjIwMzIzMDAw
'' SIG '' MDAwWhcNMzcwMzIyMjM1OTU5WjBjMQswCQYDVQQGEwJV
'' SIG '' UzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xOzA5BgNV
'' SIG '' BAMTMkRpZ2lDZXJ0IFRydXN0ZWQgRzQgUlNBNDA5NiBT
'' SIG '' SEEyNTYgVGltZVN0YW1waW5nIENBMIICIjANBgkqhkiG
'' SIG '' 9w0BAQEFAAOCAg8AMIICCgKCAgEAxoY1BkmzwT1ySVFV
'' SIG '' xyUDxPKRN6mXUaHW0oPRnkyibaCwzIP5WvYRoUQVQl+k
'' SIG '' iPNo+n3znIkLf50fng8zH1ATCyZzlm34V6gCff1DtITa
'' SIG '' EfFzsbPuK4CEiiIY3+vaPcQXf6sZKz5C3GeO6lE98NZW
'' SIG '' 1OcoLevTsbV15x8GZY2UKdPZ7Gnf2ZCHRgB720RBidx8
'' SIG '' ald68Dd5n12sy+iEZLRS8nZH92GDGd1ftFQLIWhuNyG7
'' SIG '' QKxfst5Kfc71ORJn7w6lY2zkpsUdzTYNXNXmG6jBZHRA
'' SIG '' p8ByxbpOH7G1WE15/tePc5OsLDnipUjW8LAxE6lXKZYn
'' SIG '' LvWHpo9OdhVVJnCYJn+gGkcgQ+NDY4B7dW4nJZCYOjgR
'' SIG '' s/b2nuY7W+yB3iIU2YIqx5K/oN7jPqJz+ucfWmyU8lKV
'' SIG '' EStYdEAoq3NDzt9KoRxrOMUp88qqlnNCaJ+2RrOdOqPV
'' SIG '' A+C/8KI8ykLcGEh/FDTP0kyr75s9/g64ZCr6dSgkQe1C
'' SIG '' vwWcZklSUPRR8zZJTYsg0ixXNXkrqPNFYLwjjVj33GHe
'' SIG '' k/45wPmyMKVM1+mYSlg+0wOI/rOP015LdhJRk8mMDDtb
'' SIG '' iiKowSYI+RQQEgN9XyO7ZONj4KbhPvbCdLI/Hgl27Ktd
'' SIG '' RnXiYKNYCQEoAA6EVO7O6V3IXjASvUaetdN2udIOa5kM
'' SIG '' 0jO0zbECAwEAAaOCAV0wggFZMBIGA1UdEwEB/wQIMAYB
'' SIG '' Af8CAQAwHQYDVR0OBBYEFLoW2W1NhS9zKXaaL3WMaiCP
'' SIG '' nshvMB8GA1UdIwQYMBaAFOzX44LScV1kTN8uZz/nupiu
'' SIG '' HA9PMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggr
'' SIG '' BgEFBQcDCDB3BggrBgEFBQcBAQRrMGkwJAYIKwYBBQUH
'' SIG '' MAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBBBggr
'' SIG '' BgEFBQcwAoY1aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcnQwQwYD
'' SIG '' VR0fBDwwOjA4oDagNIYyaHR0cDovL2NybDMuZGlnaWNl
'' SIG '' cnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcmww
'' SIG '' IAYDVR0gBBkwFzAIBgZngQwBBAIwCwYJYIZIAYb9bAcB
'' SIG '' MA0GCSqGSIb3DQEBCwUAA4ICAQB9WY7Ak7ZvmKlEIgF+
'' SIG '' ZtbYIULhsBguEE0TzzBTzr8Y+8dQXeJLKftwig2qKWn8
'' SIG '' acHPHQfpPmDI2AvlXFvXbYf6hCAlNDFnzbYSlm/EUExi
'' SIG '' HQwIgqgWvalWzxVzjQEiJc6VaT9Hd/tydBTX/6tPiix6
'' SIG '' q4XNQ1/tYLaqT5Fmniye4Iqs5f2MvGQmh2ySvZ180HAK
'' SIG '' fO+ovHVPulr3qRCyXen/KFSJ8NWKcXZl2szwcqMj+sAn
'' SIG '' gkSumScbqyQeJsG33irr9p6xeZmBo1aGqwpFyd/EjaDn
'' SIG '' mPv7pp1yr8THwcFqcdnGE4AJxLafzYeHJLtPo0m5d2aR
'' SIG '' 8XKc6UsCUqc3fpNTrDsdCEkPlM05et3/JWOZJyw9P2un
'' SIG '' 8WbDQc1PtkCbISFA0LcTJM3cHXg65J6t5TRxktcma+Q4
'' SIG '' c6umAU+9Pzt4rUyt+8SVe+0KXzM5h0F4ejjpnOHdI/0d
'' SIG '' KNPH+ejxmF/7K9h+8kaddSweJywm228Vex4Ziza4k9Tm
'' SIG '' 8heZWcpw8De/mADfIBZPJ/tgZxahZrrdVcA6KYawmKAr
'' SIG '' 7ZVBtzrVFZgxtGIJDwq9gdkT/r+k0fNX2bwE+oLeMt8E
'' SIG '' ifAAzV3C+dAjfwAL5HYCJtnwZXZCpimHCUcr5n8apIUP
'' SIG '' /JiW9lVUKx+A+sDyDivl1vupL0QVSucTDh3bNzgaoSv2
'' SIG '' 7dZ8/DCCBY0wggR1oAMCAQICEA6bGI750C3n79tQ4ghA
'' SIG '' GFowDQYJKoZIhvcNAQEMBQAwZTELMAkGA1UEBhMCVVMx
'' SIG '' FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQ
'' SIG '' d3d3LmRpZ2ljZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNl
'' SIG '' cnQgQXNzdXJlZCBJRCBSb290IENBMB4XDTIyMDgwMTAw
'' SIG '' MDAwMFoXDTMxMTEwOTIzNTk1OVowYjELMAkGA1UEBhMC
'' SIG '' VVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UE
'' SIG '' CxMQd3d3LmRpZ2ljZXJ0LmNvbTEhMB8GA1UEAxMYRGln
'' SIG '' aUNlcnQgVHJ1c3RlZCBSb290IEc0MIICIjANBgkqhkiG
'' SIG '' 9w0BAQEFAAOCAg8AMIICCgKCAgEAv+aQc2jeu+RdSjww
'' SIG '' IjBpM+zCpyUuySE98orYWcLhKac9WKt2ms2uexuEDcQw
'' SIG '' H/MbpDgW61bGl20dq7J58soR0uRf1gU8Ug9SH8aeFaV+
'' SIG '' vp+pVxZZVXKvaJNwwrK6dZlqczKU0RBEEC7fgvMHhOZ0
'' SIG '' O21x4i0MG+4g1ckgHWMpLc7sXk7Ik/ghYZs06wXGXuxb
'' SIG '' Grzryc/NrDRAX7F6Zu53yEioZldXn1RYjgwrt0+nMNlW
'' SIG '' 7sp7XeOtyU9e5TXnMcvak17cjo+A2raRmECQecN4x7ax
'' SIG '' xLVqGDgDEI3Y1DekLgV9iPWCPhCRcKtVgkEy19sEcypu
'' SIG '' kQF8IUzUvK4bA3VdeGbZOjFEmjNAvwjXWkmkwuapoGfd
'' SIG '' pCe8oU85tRFYF/ckXEaPZPfBaYh2mHY9WV1CdoeJl2l6
'' SIG '' SPDgohIbZpp0yt5LHucOY67m1O+SkjqePdwA5EUlibaa
'' SIG '' RBkrfsCUtNJhbesz2cXfSwQAzH0clcOP9yGyshG3u3/y
'' SIG '' 1YxwLEFgqrFjGESVGnZifvaAsPvoZKYz0YkH4b235kOk
'' SIG '' GLimdwHhD5QMIR2yVCkliWzlDlJRR3S+Jqy2QXXeeqxf
'' SIG '' jT/JvNNBERJb5RBQ6zHFynIWIgnffEx1P2PsIV/EIFFr
'' SIG '' b7GrhotPwtZFX50g/KEexcCPorF+CiaZ9eRpL5gdLfXZ
'' SIG '' qbId5RsCAwEAAaOCATowggE2MA8GA1UdEwEB/wQFMAMB
'' SIG '' Af8wHQYDVR0OBBYEFOzX44LScV1kTN8uZz/nupiuHA9P
'' SIG '' MB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6enIZ3zbcgP
'' SIG '' MA4GA1UdDwEB/wQEAwIBhjB5BggrBgEFBQcBAQRtMGsw
'' SIG '' JAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0
'' SIG '' LmNvbTBDBggrBgEFBQcwAoY3aHR0cDovL2NhY2VydHMu
'' SIG '' ZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9v
'' SIG '' dENBLmNydDBFBgNVHR8EPjA8MDqgOKA2hjRodHRwOi8v
'' SIG '' Y3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVk
'' SIG '' SURSb290Q0EuY3JsMBEGA1UdIAQKMAgwBgYEVR0gADAN
'' SIG '' BgkqhkiG9w0BAQwFAAOCAQEAcKC/Q1xV5zhfoKN0Gz22
'' SIG '' Ftf3v1cHvZqsoYcs7IVeqRq7IviHGmlUIu2kiHdtvRoU
'' SIG '' 9BNKei8ttzjv9P+Aufih9/Jy3iS8UgPITtAq3votVs/5
'' SIG '' 9PesMHqai7Je1M/RQ0SbQyHrlnKhSLSZy51PpwYDE3cn
'' SIG '' RNTnf+hZqPC/Lwum6fI0POz3A8eHqNJMQBk1RmppVLC4
'' SIG '' oVaO7KTVPeix3P0c2PR3WlxUjG/voVA9/HYJaISfb8rb
'' SIG '' II01YBwCA8sgsKxYoA5AY8WYIsGyWfVVa88nq2x2zm8j
'' SIG '' LfR+cWojayL/ErhULSd+2DrZ8LaHlv1b0VysGMNNn3O3
'' SIG '' AamfV6peKOK5lDGCA3YwggNyAgEBMHcwYzELMAkGA1UE
'' SIG '' BhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTsw
'' SIG '' OQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQw
'' SIG '' OTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQQIQBUSv85Sd
'' SIG '' CDmmv9s/X+VhFjANBglghkgBZQMEAgEFAKCB0TAaBgkq
'' SIG '' hkiG9w0BCQMxDQYLKoZIhvcNAQkQAQQwHAYJKoZIhvcN
'' SIG '' AQkFMQ8XDTI0MDEyNjIzNTQ0MlowKwYLKoZIhvcNAQkQ
'' SIG '' AgwxHDAaMBgwFgQUZvArMsLCyQ+CXc6qisnGTxmcz0Aw
'' SIG '' LwYJKoZIhvcNAQkEMSIEIDGQxEf5n3QL60sGYFB8vhjC
'' SIG '' q0yWFTcboXN1BAeTi4FXMDcGCyqGSIb3DQEJEAIvMSgw
'' SIG '' JjAkMCIEINL25G3tdCLM0dRAV2hBNm+CitpVmq4zFq9N
'' SIG '' GprUDHgoMA0GCSqGSIb3DQEBAQUABIICABE/a2E5N2E0
'' SIG '' jXIePR65qlixOsj6FxF8RKpImtuVVB7PKWG1tw38Hsd8
'' SIG '' cJ+BavcGqBv9WIOD2PCETpbcm2K8KA5lYLKeWVIAyjms
'' SIG '' 9XJqYFT43kOPUcOXpE24Mfy7NNOAMlKRKDTHKpW02h9n
'' SIG '' dWagbBs7PbWY5XKerPuggQJkbNpPK9jY7txUWPKl7AQy
'' SIG '' Lf/Iqz96PCu8ldyQ/1hNFmXHO7iVqCnxhz7NTFR4dBxL
'' SIG '' cpudC9Vu3vP16XREnU0JsqCdDOEGRWOXehCL8XzShnk6
'' SIG '' xjHELVno973bXKH0XmBTJKEQu/mn7/HkrRcCDuzu9y1Y
'' SIG '' 6ETNPlwPAin6Q1TkGBqxDps3WIgZJKbx3sypQy23omkX
'' SIG '' L+iJf5roJGpcMDIgh1ga8ob11Z7SegBgwOHYGHhAdGy6
'' SIG '' KhlZGEMEqqIbspXsA6W9W9ObuxJpA9VclEI7rem01IA0
'' SIG '' Ntqvwrr+ZK4ha6yQYCQceRJzvWql8KLUWV3oSt9gXJnd
'' SIG '' MXFPbKIEeDLaDkKSZabCrlfK3TLlbi/6s/iiy5GadrVy
'' SIG '' /IL5BT3ZEQLf5ru2+kxjUMoKZdnQ7l+xvCpvomfDGdFX
'' SIG '' xGrS3x1z/R6mmJTMWXJygXPkFSk+0W/9/aOSHuuLR1p9
'' SIG '' xZbLR4VtGTH0SUMhk1HF+ld8/pOrx4R1S82jeIjxyeue
'' SIG '' XF3j3tVElX42
'' SIG '' End signature block
